# WebDAV服务器

这是一个基于PHP的WebDAV服务器，支持用户认证和文件管理功能。

## 系统要求

- PHP 7.3 或更低版本
- PDO SQLite 扩展
- 可写权限的目录

## 安装说明

1. 将所有文件上传到您的Web服务器
2. 确保 `db` 和 `storage` 目录具有可写权限
3. 访问 `install.php` 开始安装
4. 按照安装向导设置管理员账号和基础目录
5. 安装完成后，您可以访问 `admin.php` 管理用户和设置

## 功能特点

- 基于SQLite数据库的用户管理
- 管理员可以添加、删除和修改用户
- 支持WebDAV协议，可与各种客户端兼容
- 安全的密码存储（使用PHP密码哈希）
- 随机生成的数据库文件名和存储目录

## 使用方法

### 管理后台

访问 `admin.php` 并使用管理员账号登录，您可以：

- 修改您的用户名和密码
- 管理其他用户账号
- 查看WebDAV连接信息

### WebDAV访问

您可以使用以下信息连接到WebDAV服务：

- WebDAV地址：`http://您的域名/webdav.php`
- 用户名：您的用户名
- 密码：您的密码

支持的客户端包括：

- Windows资源管理器
- macOS Finder
- 各种WebDAV客户端应用

## 安全说明

- 所有密码都使用PHP的`password_hash`函数进行加密存储
- 数据库文件名随机生成，提高安全性
- 存储目录使用随机名称，可自定义

## 故障排除

如果遇到问题：

1. 确保PHP版本兼容（7.3或更低）
2. 检查PDO SQLite扩展是否已启用
3. 验证目录权限是否正确
4. 查看PHP错误日志获取详细信息